UNIT CSG;

{ CSG         - Support routines for constructive solid geometrie, most of them
                are taken from SGI's advanced programming samples
  Version     - 0.1.1
  Last Change - 08 June 1997
  for more information see history
}

INTERFACE

USES GL, GLU;

TYPE TCSGOperation = (A_OR_B,A_AND_B,A_SUB_B);
     TCSGGroup     = (CSG_A,CSG_B);

PROCEDURE CSG_DoAND(A,B: ARRAY OF GLEnum);
PROCEDURE CSG_DoOR(A,B: ARRAY OF GLEnum);
PROCEDURE CSG_DoSUB(A,B: ARRAY OF GLEnum);

//------------------------------------------------------------------------------

IMPLEMENTATION

//------------------------------------------------------------------------------

PROCEDURE DrawLists(AList: ARRAY OF GLEnum);

VAR I : Integer;

BEGIN
  FOR I:=0 TO AList[0]-1 DO
  BEGIN
    glPushMatrix;
    glCallList(AList[I+1]);
    glPopMatrix;
  END;
END;

//------------------------------------------------------------------------------

PROCEDURE FirstInsideSecond(A,B: ARRAY OF GLEnum; Face, Test: GLEnum);

{Set stencil buffer to show the part of A (front or back face) that's inside B's volume.
 Requirements: GL_CULL_FACE enabled, depth func GL_LESS
 Side effects: depth test, stencil test, stencil op}

VAR I : Integer;

BEGIN
  glEnable(GL_DEPTH_TEST);
  glColorMask(GL_FALSE,GL_FALSE,GL_FALSE,GL_FALSE);
  glCullFace(Face);  // controls which face of A to use
  DrawLists(A);      // draw a face of A into depth buffer
  // use stencil plane to find parts of B in A
  glDepthMask(GL_FALSE);
  glEnable(GL_STENCIL_TEST);
  glStencilFunc(GL_ALWAYS,0,0);
  glStencilOp(GL_KEEP,GL_KEEP,GL_INCR);
  glCullFace(GL_BACK);
  // increment the stencil where the front face of B is drawn
  DrawLists(B);
  glStencilOp(GL_KEEP,GL_KEEP,GL_DECR);
  glCullFace(GL_FRONT);
  // decrement the stencil buffer where the back of B is drawn
  DrawLists(B);
  glDepthMask(GL_TRUE);
  glColorMask(GL_TRUE,GL_TRUE,GL_TRUE,GL_TRUE);
  glStencilFunc(Test,0,1);
  glDisable(GL_DEPTH_TEST);
  glCullFace(Face);
  DrawLists(A);  // draw the part of A that's in B
END;

//------------------------------------------------------------------------------

PROCEDURE FixDepth(A: ARRAY OF GLEnum);

VAR I : Integer;

BEGIN
  glColorMask(GL_FALSE,GL_FALSE,GL_FALSE,GL_FALSE);
  glEnable(GL_DEPTH_TEST);
  glDisable(GL_STENCIL_TEST);
  glDepthFunc(GL_ALWAYS);
  DrawLists(A);
  glDepthFunc(GL_LESS);
END;

//------------------------------------------------------------------------------

PROCEDURE CSG_DoAND(A,B: ARRAY OF GLEnum);

{Draw all parts of the OR'ed objects of A and the OR'ed objects of B, which
 are in both.}

BEGIN
  FirstInsideSecond(B,A,GL_BACK,GL_NOTEQUAL);
  FixDepth(A);
  FirstInsideSecond(A,B,GL_BACK,GL_NOTEQUAL);
  glDisable(GL_STENCIL_TEST);
END;

//------------------------------------------------------------------------------

PROCEDURE CSG_DoOR(A,B: ARRAY OF GLEnum);

// doing OR is really easy, simply draw all objects

BEGIN
  DrawLists(A);
  DrawLists(B);
END;

//------------------------------------------------------------------------------

PROCEDURE CSG_DoSUB(A,B: ARRAY OF GLEnum);

{Draw all parts of the OR'ed objects of A and the OR'ed objects of B, which
 are in A but not in B.}

BEGIN
  FirstInsideSecond(B,A,GL_FRONT,GL_NOTEQUAL);
  FixDepth(A);
  FirstInsideSecond(A,B,GL_BACK,GL_EQUAL);
  glDisable(GL_STENCIL_TEST);
END;

//------------------------------------------------------------------------------

END.
